/*
Opleiding	: Basisvaardigheden SQL Query's schrijven van SQLTeam.NL
Module		: Data uit meerdere tabellen halen

-- Voordat je begint
DROP TABLE IF EXISTS #Klantentabel
DROP TABLE IF EXISTS #Ordertabel
*/

/* Aanmaken van de tabellen */
CREATE TABLE #Klantentabel (
	Klantnummer	int,
	Naam		varchar(50),
	Adres		varchar(50),
	Woonplaats	varchar(50)
);

CREATE TABLE #Ordertabel (
	Ordernummer	int,
	Klantnummer	int,
	Orderbedrag	decimal(10,2)
);

/* Tabellen vullen met data */
INSERT INTO #Klantentabel (
	Klantnummer,
	Naam,
	Adres,
	Woonplaats
)
VALUES
	(1,'Pietje','Teststraat 1','Teststad'),
	(2,'Marietje','Teststraat 2','Teststad'),
	(3,'Peter','Teststraat 3','Teststad'),
	(4,'Elsa','Teststraat 4','Teststad'),
	(5,'Harry','Teststraat 5','Teststad'),
	(6,'Barry','Teststraat 6','Teststad'),
	(9,'Frans','Teststraat 7','Teststad'),
	(10,'Katrien','Teststraat 8','Teststad');

INSERT INTO #Ordertabel (
	Ordernummer,
	Klantnummer,
	Orderbedrag
)
VALUES
	(10,1,10.50),
	(11,2,12.50),
	(12,3,14.50),
	(13,4,15.00),
	(14,5,17.50),
	(15,6,20.00),
	(16,7,22.50),
	(17,8,25.00),
	(18,1,27.50),
	(19,1,30.00),
	(20,1,32.50)

/* Voorbeeld met een FULL JOIN */
SELECT
k.Klantnummer,
k.Naam,
o.*
FROM #Klantentabel k
FULL JOIN #Ordertabel o		ON k.Klantnummer = o.Klantnummer

/* Voorbeeld met een INNER join */
SELECT
k.Klantnummer,
k.Naam,
o.*
FROM #Klantentabel k
INNER JOIN #Ordertabel o		ON k.Klantnummer = o.Klantnummer

/* Voorbeeld met een LEFT JOIN */
SELECT
k.Klantnummer,
k.Naam,
o.*
FROM #Klantentabel k
LEFT JOIN #Ordertabel o		ON k.Klantnummer = o.Klantnummer

/* Voorbeeld met een RIGHT JOIN (gebruik raad ik af!) */
SELECT
k.Klantnummer,
k.Naam,
o.*
FROM #Klantentabel k
RIGHT JOIN #Ordertabel o		ON k.Klantnummer = o.Klantnummer

/* ... want het voorbeeld met de RIGHT JOIN kan ook met een LEFT JOIN... */
SELECT
k.Klantnummer,
k.Naam,
o.*
FROM #Ordertabel o
LEFT JOIN #Klantentabel k		ON k.Klantnummer = o.Klantnummer

-- Wanneer ik alle klanten zonder orders wil zien...
SELECT
k.Klantnummer,
k.Naam,
o.*
FROM #Klantentabel k
LEFT JOIN #Ordertabel o		ON k.Klantnummer = o.Klantnummer
WHERE o.Klantnummer IS NULL

/* Praktijksituatie met join */
SELECT
	o.Ordernummer,
	o.Klantnummer,
	k.Klantnummer,
	k.Naam,
	k.Adres,
	k.Woonplaats,
	o.Orderbedrag
FROM #Ordertabel o
JOIN #Klantentabel k ON o.Klantnummer = k.Klantnummer
ORDER BY o.Klantnummer, o.Orderbedrag DESC

/* Praktijksituatie met aggregatie */
SELECT
	k.Klantnummer			AS Klantnummer,
	k.Naam					AS Klantnaam,
	COUNT(o.ordernummer)	AS AantalOrders,
	SUM(o.Orderbedrag)		AS TotaalOrderbedrag,
	AVG(o.Orderbedrag)		AS GemiddeldOrderbedrag
FROM #Ordertabel o
LEFT JOIN #Klantentabel k ON o.Klantnummer = k.Klantnummer
GROUP BY k.Klantnummer, k.Naam
ORDER BY k.Klantnummer

-- Andersom geredeneerd: geef mij alle klanten met evt. orders
SELECT
	k.Klantnummer			AS Klantnummer,
	k.Naam					AS Klantnaam,
	COUNT(o.ordernummer)	AS AantalOrders,
	SUM(o.Orderbedrag)		AS TotaalOrderbedrag,
	AVG(o.Orderbedrag)		AS GemiddeldOrderbedrag
FROM #Klantentabel k
LEFT JOIN #Ordertabel o ON o.Klantnummer = k.Klantnummer
GROUP BY k.Klantnummer, k.Naam
ORDER BY k.Klantnummer

-- Zelfde query, maar dan met COALESCE functie
SELECT
	k.Klantnummer					AS Klantnummer,
	k.Naam							AS Klantnaam,
	COUNT(o.ordernummer)			AS AantalOrders,
	COALESCE(SUM(o.Orderbedrag),0)	AS TotaalOrderbedrag,
	COALESCE(AVG(o.Orderbedrag),0)	AS GemiddeldOrderbedrag
FROM #Klantentabel k
LEFT JOIN #Ordertabel o ON o.Klantnummer = k.Klantnummer
GROUP BY k.Klantnummer, k.Naam
ORDER BY k.Klantnummer
